/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.actions.AbstractDynamicBranchItem;
import com.aptana.git.ui.internal.actions.PushTagsHandler;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class PushTagsItem
extends AbstractDynamicBranchItem {
    public PushTagsItem() {
    }

    public PushTagsItem(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        IResource resource = this.getSelectedResource();
        if (resource == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        GitRepository repo = this.getGitRepositoryManager().getAttached(resource.getProject());
        if (repo == null) {
            return NO_CONTRIBUTION_ITEMS;
        }
        ArrayList<RemoteContributionItem> contributions = new ArrayList<RemoteContributionItem>();
        for (String remote : repo.remotes()) {
            contributions.add(new RemoteContributionItem(repo, remote));
        }
        return contributions.toArray(new IContributionItem[contributions.size()]);
    }

    private static class RemoteContributionItem
    extends ContributionItem {
        private GitRepository repo;
        private String remote;

        RemoteContributionItem(GitRepository repo, String remote) {
            this.repo = repo;
            this.remote = remote;
        }

        public void fill(Menu menu, int index) {
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText(this.remote);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PushTagsHandler.pushTagsToRemote(RemoteContributionItem.this.repo, RemoteContributionItem.this.remote);
                }
            });
        }
    }
}

